subroutine getfreeunit(unit)
  !
  ! Gets the first free file unit
  ! Skip units 5,6
  ! Returns (-1) on error
  !
  use strings
  implicit none
  integer,intent(out) :: unit
  integer :: i
  character(len=9) :: fstatus
  integer, parameter :: MAXUNIT = 100   ! Maximum unit number
  unit = -1
  !
  do i=1,MAXUNIT
     if(i==5 .or. i==6) cycle
     inquire(unit=i,action=fstatus)
     if(strcompare(fstatus,'undefined')) then
        unit = i
        return
     end if
  end do
end subroutine getfreeunit
