module safeop
  ! Module for safe operations
  !
  ! Provides:
  ! function safediv(a,b)
  ! subroutine normalize(a,b)
  !
  implicit none

contains

  real(8) function safediv(a,b)
    ! Divide two numbers if denominator is not small, else return zero
    !
    implicit none
    real(8), intent(in)  :: a,b
    real(8), parameter :: RMIN   = TINY(1d0)
    safediv = 0d0
    if(abs(b) >= RMIN) safediv = a/b
  end function safediv

  subroutine normalize(a,b)
  ! Normalize the components of a 2D non-null vector
  implicit none
  real(8), intent(inout) :: a,b
  real(8) :: norm
  norm = sqrt(a**2+b**2)
  a = safediv(a,norm)
  b = safediv(b,norm)
end subroutine normalize

end module safeop
