module strings
  !
  ! This module contains utilities for strings operations
  !
  ! Author: Giovanni Macedonio
  !
  ! Version: 1.0
  !
  ! Date of first version: 20-MAR-2011
  ! Date of this  version: 20-MAR-2011
  !
  ! uppercase  - Convert string to uppercase
  ! lowercase  - Convert string to lowercase
  ! strcompare - Compare two strings (logical function)

contains

  subroutine uppercase(str)
    ! Convert a string to uppercase
    implicit none
    character(len=*), intent(in out) :: str
    integer :: i, del

    del = iachar('a') - iachar('A')

    do i = 1, len_trim(str)
       if (lge(str(i:i),'a') .and. lle(str(i:i),'z')) then
          str(i:i) = achar(iachar(str(i:i)) - del)
       end if
    end do

    return
  end subroutine uppercase
  !
  subroutine lowercase(str)
    ! Convert a string to lowercase
    implicit none
    character(len=*), intent(in out) :: str
    integer :: i, del

    del = iachar('a') - iachar('A')

    do i = 1, len_trim(str)
       if (lge(str(i:i),'A') .and. lle(str(i:i),'Z')) then
          str(i:i) = achar(iachar(str(i:i)) + del)
       end if
    end do

    return

  end subroutine lowercase
  !
  function strcompare(str1,str2)
    ! Compare two strings
    !
    ! Strings are first converted to uppercase, then are compared
    !
    logical :: strcompare
    character(len=*), intent(in) :: str1,str2
    character(len=len_trim(str1)) :: nstr1
    character(len=len_trim(str2)) :: nstr2
    !
    ! Copy
    nstr1 = str1
    nstr2 = str2
    !
    ! Convert to uppercase
    call uppercase(nstr1)
    call uppercase(nstr2)
    !
    ! Compare
    if(TRIM(nstr1) == TRIM(nstr2)) then
       strcompare = .true.
    else
       strcompare = .false.
    endif
  end function strcompare

end module strings
